@echo off
chcp 65001 >nul 2>&1
title .NET 8 Desktop Runtime 설치

echo ============================================
echo   DHCalcStudio - .NET 8 런타임 설치
echo ============================================
echo.

:: .NET 8 이미 설치되어 있는지 확인
dotnet --list-runtimes 2>nul | findstr /C:"Microsoft.WindowsDesktop.App 8." >nul 2>&1
if %ERRORLEVEL% EQU 0 (
    echo [OK] .NET 8 Desktop Runtime이 이미 설치되어 있습니다.
    echo.
    echo DHCalcStudio.exe를 바로 실행할 수 있습니다.
    echo.
    pause
    exit /b 0
)

echo .NET 8 Desktop Runtime이 설치되어 있지 않습니다.
echo 설치를 진행합니다...
echo.

:: 다운로드 폴더 설정
set "INSTALLER=%TEMP%\windowsdesktop-runtime-8.0-win-x64.exe"
set "DOWNLOAD_URL=https://aka.ms/dotnet/8.0/windowsdesktop-runtime-win-x64.exe"

echo [1/3] .NET 8 Desktop Runtime 다운로드 중...
echo       URL: %DOWNLOAD_URL%
echo.

:: PowerShell로 다운로드
powershell -NoProfile -Command "try { [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; (New-Object Net.WebClient).DownloadFile('%DOWNLOAD_URL%', '%INSTALLER%'); Write-Host '[OK] 다운로드 완료' } catch { Write-Host '[ERROR] 다운로드 실패:' $_.Exception.Message; exit 1 }"
if %ERRORLEVEL% NEQ 0 (
    echo.
    echo 자동 다운로드에 실패했습니다.
    echo 아래 링크에서 직접 다운로드하세요:
    echo.
    echo   https://dotnet.microsoft.com/ko-kr/download/dotnet/8.0
    echo.
    echo "Windows x64" 항목의 ".NET Desktop Runtime 8.0" 을 다운로드하세요.
    echo.
    pause
    exit /b 1
)

echo.
echo [2/3] 설치 프로그램 실행 중... (관리자 권한이 필요할 수 있습니다)
echo.

:: 설치 실행 (/passive = 진행률 표시, /norestart = 재부팅 안 함)
"%INSTALLER%" /install /passive /norestart

if %ERRORLEVEL% EQU 0 (
    echo.
    echo [3/3] 설치 완료!
) else if %ERRORLEVEL% EQU 3010 (
    echo.
    echo [3/3] 설치 완료! (재부팅이 권장됩니다)
) else (
    echo.
    echo [ERROR] 설치 중 오류가 발생했습니다. (코드: %ERRORLEVEL%)
    echo 아래 링크에서 직접 설치하세요:
    echo   https://dotnet.microsoft.com/ko-kr/download/dotnet/8.0
)

:: 임시 파일 삭제
del "%INSTALLER%" 2>nul

echo.
echo ============================================
echo   이제 DHCalcStudio.exe를 실행할 수 있습니다.
echo ============================================
echo.
pause
